#ifndef RWODS_WEIGHTS_HPP
#define RWODS_WEIGHTS_HPP

#include <vector>
#include <string>

#include "pattern.hpp"

struct weights
{
  weights(const std::vector<std::string>&cue_labels,const std::vector<std::string>&target_labels):
    x_(cue_labels.size(),std::vector<double>(target_labels.size(),0.0)),
    cue_labels_(cue_labels),
    target_labels_(target_labels)
  {}

  weights(const std::string& filename);
  
  std::vector<double> predict(const pattern&)const;
  std::vector<double> selective_predict(const pattern&,const std::vector<int>&)const;
  double selective_predict(const pattern&,int)const;

  void adjust_cue(const std::vector<double>&,int);

  void save(const std::string& filename);

  private:
  
  std::vector<std::vector<double> > x_;
  std::vector<std::string> cue_labels_,target_labels_;
};

#endif
