#include "weights.hpp"

#include <fstream>
#include <sstream>
#include <limits>
#include <iostream>

weights::weights(const std::string& filename)
{
  std::ifstream i(filename);
  std::string s,si;
  std::getline(i,s);
  std::stringstream ss(s);
  std::getline(ss,si,',');
  while(std::getline(ss,si,','))
  {
    target_labels_.push_back(si);
  }
  while(std::getline(i,s))
  {
    x_.push_back(std::vector<double>());
    std::stringstream ss2(s);
    std::getline(ss2,si,',');
    cue_labels_.push_back(si);
    while(std::getline(ss2,si,','))
    {
      std::stringstream ss3(si);
      double sid;
      ss3>>sid;
      x_.back().push_back(sid);
    }
  }
}

std::vector<double> weights::predict(const pattern&p)const
{
  std::vector<double> ret(target_labels_.size(),0.);
  
  #pragma omp parallel for
  for(int i=0;i<p.size();++i)
  {
    const std::vector<double>& c=x_[p[i]];
    for(int j=0;j<ret.size();++j)
    {
      ret[j]+=c[j];
    }
  }
  return ret;
}

std::vector<double> weights::selective_predict(const pattern&p,const std::vector<int>&ts)const
{
  std::vector<double> ret(ts.size(),0.);
  
  for(int i=0;i<p.size();++i)
  {
    const std::vector<double>& c=x_[p[i]];
    for(int j=0;j<ts.size();++j)
    {
      ret[j]+=c[ts[j]];
    }
  }
  return ret;
}

double weights::selective_predict(const pattern&p,int t)const
{
  if(t==-1) return std::numeric_limits<double>::quiet_NaN();
  double ret=0.;
  
  for(int i=0;i<p.size();++i)
  {
    ret+=x_[p[i]][t];
  }
  return ret;
}

void weights::adjust_cue(const std::vector<double>&vd,int i)
{
  #pragma omp parallel for
  for(int j=0;j<vd.size();++j)
  {
    x_[i][j]+=vd[j];
  }
}

void weights::save(const std::string& filename)
{
  std::ofstream f(filename);
  
  for(int j=0;j<target_labels_.size();++j)
  {
    f<<","<<target_labels_[j];  
  }
  f<<"\n";

  for(int i=0;i<cue_labels_.size();++i)
  {
    f<<cue_labels_[i];
    for(int j=0;j<target_labels_.size();++j)
    {
      f<<","<<x_[i][j];
    }
    f<<"\n";
  }
}

