#include "uncap_trainer.hpp"

void uncap_trainer::train(weights&w,const pattern&p,int s)
{
  std::vector<double> delta=w.predict(p);
  for(int i=0;i<delta.size();++i)
  {
    delta[i]=-delta[i];
  }
  double hold=delta[s]+1;
  if(hold<0) hold=0;
  #pragma omp parallel for
  for(int i=0;i<delta.size();++i)
  {
    if(delta[i]>0) 
      delta[i]=0; 
    else
      delta[i]*=alpha_;
  }
  delta[s]=hold*alpha_;
  
  for(int l=0;l<p.size();++l)
  {
    w.adjust_cue(delta,p[l]);
  }
}

