#include "slot_encoder.hpp"

#include <set>
#include <sstream>

void slot_encoder::set_elements(const vocab&v)
{

  for(int i=0;i<v.words().size();++i)
  {
    int j=0;
    for(;j<v.words()[i].length();++j)
    {
      letters_.insert(v.words()[i][j]);
    }
    if(j>len_) len_=j;
    
  }
  
  int ii=0;
  element_names_.push_back("bias");
  for(auto i=letters_.begin();i!=letters_.end();++i,++ii)
  {
    letnum_[*i]=ii;
    for(int j=0;j<len_;++j)
    {
      std::stringstream ss;
      ss<<*i<<j;
      element_names_.push_back(ss.str());
    }
    
  }
}

std::vector<pattern> slot_encoder::encode_strings(const std::vector<std::string>&vs)const
{
  std::vector<pattern> vp(vs.size());
  int j=0;
  for(auto i=vs.begin();i!=vs.end();++i,++j)
  {
    vp[j].push_back(0);
    for(int l=0;l<i->length();++l)
    {
      auto ln=letnum_.find((*i)[l]);
      vp[j].push_back(1+ln->second*len_+l);
    }
  }
  return vp;
}

