#include "vocab.hpp"
#include "pattern.hpp"
#include "encoder.hpp"
#include "bagb_encoder.hpp"
#include "weights.hpp"
#include "trainer.hpp"
#include "uncap_trainer.hpp"

#include <cstdlib>

int main(int argc,char*argv[])
{
  vocab v;
  v.load(argv[1]);
  encoder*enc=new bagb_encoder;
  enc->set_elements(v);
  pattern_pool pp=enc->encode_vocab_patterns(v);
  weights w(enc->element_names(),v.words());
  trainer* t=new uncap_trainer(std::atof(argv[2]));
  t->multitrain(w,pp,std::atol(argv[3]));
  w.save(argv[4]);
  delete enc;
  delete t;
}
