#ifndef RWODS_PATTERN_HPP
#define RWODS_PATTERN_HPP

#include <vector>
#include <random>

typedef std::vector<int> pattern;

struct pattern_pool
{
  pattern_pool(const std::vector<pattern>& p,const std::vector<double>&cf,double maxf):
    patterns_(p),cumfreqs_(cf),maxf_(maxf)
  {}

  std::pair<int,std::vector<pattern>::const_iterator > rpattern() const;

  private:
  
  std::vector<pattern> patterns_;
  std::vector<double> cumfreqs_;
  double maxf_;
  
  mutable std::mt19937 r_;
  std::uniform_real_distribution<> d;
};

#endif
