# This is illustrative code for those unfamiliar with C++
# Actual simulations were run with the C++ code available with this archive,
#   for reasons of speed, so in the case of any unintended differences,
#   the C++ code is definitive

# SET UP VOCAB
vocab<-read.table("sub4",header=T,stringsAsFactors=F)
colnames(vocab)<-c("words","freq")
vocab<-subset(vocab,freq>2000) # speed things up; all words in sub4 were used in actual simulations

nw<-nrow(vocab)
cf<-cumsum(vocab$freq)
tf<-cf[nw]

letters<-sort(unique(unlist(strsplit(vocab$words,split=""))))

# common training function
delta<-function(weights,alpha,feats) # weight update function
{
  stim<-rword()
  stimfeats<-feats[[stim]]

  prediction<-apply(weights[,stimfeats],1,sum)
  del<- -prediction
  del[stim] <- del[stim]+1
  hold<-del[stim]
  if(hold<0) hold<-0; # never decrease weights to the presented word

  del <- ifelse(del>0,0,del*alpha) # never increase weights to unpresented words

  del[stim]<-hold*alpha
  weights[,stimfeats]<-weights[,stimfeats]+del

  weights
}

# code unique to SLOT-CODED model
slotletters<-c("bias",as.vector(outer(letters,1:max(nchar(vocab$words)),paste,sep="")))

rword<-function() match(0,runif(1,0,tf)>cf)

slot_encode<-function(stims) {
lapply(
  strsplit(stims,split=""),
  function(x) 
    c(1,as.numeric(
      factor(levels=slotletters,paste(x,1:length(x),sep=""))
    ))
)
}
predict_new<-function(stimulus,weights)
{
  lapply(slot_encode(stimulus),function(x) apply(weights[,x],1,sum))
}

predict_new_sel<-function(stimulus,weights,sel=1:nrow(weights))
{
  if(length(sel)>1) 
    return(lapply(slot_encode(stimulus),function(x) apply(weights[sel,x],1,sum)))
  lapply(slot_encode(stimulus),function(x) sum(weights[sel,x]))
}

slotwordfeats<-slot_encode(vocab$words)

# TRAIN WEIGHT MATRIX (SLOT)
slotweights<-matrix(0,ncol=length(slotletters),nrow=nw)
colnames(slotweights)<-slotletters
rownames(slotweights)<-vocab$words
for(i in 1:100000) # actual simulations use 20m
{
  slotweights<-delta(slotweights,.002,slotwordfeats)
}

# TEST FUNCTION (SLOT)
priming<-function(targets,primes,weights)
{
  sel<-match(targets,vocab$words)
  ret<-sapply(1:length(targets),
    function(i) {
      unlist(predict_new_sel(unlist(as.list(primes[i,])),weights,sel[i]))
    }
  )
  colnames(ret)<-targets
  t(ret)
}

primes_and_targets<-read.table("neigh",header=T,stringsAsFactors=F)
targets<-primes_and_targets[,1]
primes<-primes_and_targets[,-1]

preds<-priming(targets,primes,slotweights)
apply(preds,2,mean,na.rm=T)

#POSITION FREE LETTERS "BAG OF LETTERS" MODEL
bagletters<-c("bias",as.vector(outer(letters,1:4,paste,sep="")))

bag_encode<-function(stims) {
  lapply(
    strsplit(stims,split=""),
    function(x){
      table(x)->tx; 
      ret<-factor(levels=bagletters,
             c(paste(names(tx[tx>0]),"1",sep=""),
               paste(names(tx[tx>1]),"2",sep=""),
               paste(names(tx[tx>2]),"3",sep=""),
               paste(names(tx[tx>2]),"4",sep="")
              )
            )
      ret[!is.na(ret)]
    }
  )
}

predict_new_bag<-function(stimulus,weights)
{
  lapply(bag_encode(stimulus),function(x) apply(weights[,x],1,sum))
}

predict_new_sel_bag<-function(stimulus,weights,sel=1:nrow(weights))
{
  if(length(sel)>1) 
    return(lapply(bag_encode(stimulus),function(x) apply(weights[sel,x],1,sum)))
  lapply(bag_encode(stimulus),function(x) sum(weights[sel,x]))
}

# TRAIN LETTERS MODEL
bagwordfeats<-bag_encode(vocab$words)
bagweights<-matrix(0,ncol=length(bagletters),nrow=nw)
colnames(bagweights)<-bagletters
rownames(bagweights)<-vocab$words
for(i in 1:100000)
{
  bagweights<-delta(bagweights,.002,bagwordfeats)
}

# TEST LETTERS MODEL
bagpriming<-function(targets,primes,weights)
{
  sel<-match(targets,vocab$words)
  ret<-sapply(1:length(targets),
    function(i) {
      unlist(predict_new_sel_bag(unlist(as.list(primes[i,])),weights,sel[i]))
    }
  )
  colnames(ret)<-targets
  t(ret)
}

bagpreds<-bagpriming(targets,primes,bagweights)
apply(bagpreds,2,mean,na.rm=T)

#POSITION FREE LETTERS AND BIGRAMS MODEL "BAGB"
bagbnodes<-c(bagletters,
  as.vector(outer(as.vector(outer(letters,letters,paste,sep="")),1:6,paste,sep=""))
)

bigrams<-function(x)
  {
    ret<-outer(x,x,paste,sep="")
    as.vector(ret[upper.tri(ret)])
  }

bagb_encode<-function(stims) {
  lapply(
    strsplit(stims,split=""),
    function(x){
      table(x)->tx; 
      table(bigrams(x))->tb;
      ret<-factor(levels=bagbnodes,
             c(paste(names(tx[tx>0]),"1",sep=""),
               paste(names(tx[tx>1]),"2",sep=""),
               paste(names(tx[tx>2]),"3",sep=""),
               paste(names(tx[tx>3]),"4",sep=""),
               paste(names(tb[tb>0]),"1",sep=""),
               paste(names(tb[tb>1]),"2",sep=""),
               paste(names(tb[tb>2]),"3",sep=""),
               paste(names(tb[tb>3]),"4",sep=""),
               paste(names(tb[tb>4]),"5",sep=""),
               paste(names(tb[tb>5]),"6",sep="")
              )
            )
      ret[!is.na(ret)]
    }
  )
}

predict_new_bagb<-function(stimulus,weights)
{
  lapply(bagb_encode(stimulus),function(x) apply(weights[,x],1,sum))
}

predict_new_sel_bagb<-function(stimulus,weights,sel=1:nrow(weights))
{
  if(length(sel)>1) 
    return(lapply(bagb_encode(stimulus),function(x) apply(weights[sel,x],1,sum)))
  lapply(bagb_encode(stimulus),function(x) sum(weights[sel,x]))
}

# TRAIN L&B MODEL
bagbwordfeats<-bagb_encode(vocab$words)
bagbweights<-matrix(0,ncol=length(bagbnodes),nrow=nw)
colnames(bagbweights)<-bagbnodes
rownames(bagbweights)<-vocab$words
for(i in 1:100000)
{
  bagbweights<-delta(bagbweights,.002,bagbwordfeats)
}

# TEST L&B MODEL
bagbpriming<-function(targets,primes,weights)
{
  sel<-match(targets,vocab$words)
  ret<-sapply(1:length(targets),
    function(i) {
      unlist(predict_new_sel_bagb(unlist(as.list(primes[i,])),weights,sel[i]))
    }
  )
  colnames(ret)<-targets
  t(ret)
}

bagbpreds<-bagbpriming(targets,primes,bagbweights)
apply(bagbpreds,2,mean,na.rm=T)
