#include "encoder.hpp"

pattern_pool encoder::encode_vocab_patterns(const vocab&v) const
{
  std::vector<pattern> p=encode_strings(v.words());

  std::vector<double> cf(v.freqs().size());
  double c=0.;
  for(int i=0;i<v.freqs().size();++i)
  {
    c+=v.freqs()[i];
    cf[i]=c;
  }  
  
  return pattern_pool(p,cf,c);
}
