invisible(require(methods,quietly=T))
setClass("eNdataframelist",
         slots=list(dataframes="list",scripts="list",pend="character"),
         validity=function(object) {
           if(all(sapply(object@dataframes,is.data.frame)))
           {
             if(all(sapply(object@scripts,is.function)))
             {
               return(T);
             }
             "not scripts";
           } 
           "not data frames";
         }
        )
setMethod("[",
          signature(x="eNdataframelist",i="character"),
          function(x,i,j,drop) {
            eN_read(i);
            x@dataframes[[i]]
          }
         )
setMethod("[<-",
          signature(x="eNdataframelist",i="character",value="data.frame"),
          function(x,i,j,value) {
            eN_read(i);
#print(pending(eN))
#print(c("check",i));
            if(!i%in%dataframes(eN)&!i%in%pending(eN)) {
#print(c("cre ",i))
              lazyNut_exec(paste("create dataframe",i))
            }
            x@dataframes[[i]]<-value;
            eN_modification(i);
            eN_read(i);
            x
          }
         )

setGeneric("pending<-",
         def=function(x,value){standardGeneric("pending<-")})
setMethod("pending<-",
          signature(x="eNdataframelist",value="character"),
          function(x,value) {
#            print(value);
            x@pend<-value;
            x
          }
         )

setGeneric("dataframes",
         def=function(x){standardGeneric("dataframes")})
setMethod("dataframes",
          signature(x="eNdataframelist"),
          function(x) {
            names(x@dataframes);
          }
         )

setGeneric("pending",
         def=function(x){standardGeneric("pending")})
setMethod("pending",
          signature(x="eNdataframelist"),
          function(x) {
            x@pend;
          }
         )


eN<-new("eNdataframelist")

eN_colnamesplit<-function(xx){
    name<-paste(attr(xx,"colsplit"),".",sep="");
    x<-colnames(xx); 
    i=nchar(name)
    levelcolb=substring(x,1,i)==name
    if(sum(levelcolb)>0) 
      return(list(name=name,levels=substring(x[levelcolb],i+1),i=i,levelcolb=levelcolb));
    return(list(name="",levels=attr(xx,"colsplit"),i=0,levelcolb=T))
}

eN_colfactor<-function(df,x){
  factor(levels=df[x])
}

evil_parse<-function(x) eval(parse(text=x))

eN_list_format<-function(l) 
{ 
  if(is.null(l)) return("");
  ret<-character(1); 
  for(i in 1:length(names(l))) { 
    if(substr(names(l)[i],1,1)!="_"&&l[i]!="*"){
      ret[1]<-paste(ret[1],names(l)[i],"=",l[i],"; ",sep="") 
    }
  }; 
  ret[1]<-paste(strwrap(ret[1],dev.size()[1]*12),collapse="\n")
  ret
}
