function(                                                  # A BAR PLOT OF MEANS BY CATEGORIES
         df=factor(levels=dataframes(eN))[[1]],           # Dataframe                     # Dataframe with DV(s) and IV(s)
         ys=factor(NULL,levels=colnames(df)),                   # Dependent Variables            # name of column(s) in dataframe to be averaged
         exclude=1000,                                     # Dependent Variables          # exclude trials with values on DV greater than this value
         classify=factor(NULL,levels=colnames(df)),        # Independent Variables         # IV(s) from df (if any)
         min.y=.0,                                              # Cosmetic # lower limit on y-axis (ignored if equal upper limit)
         max.y=.0,                                               # Cosmetic # upper limit on y-axis (ignored if equal lower limit)
         min.ysep=.0                                               # Cosmetic # minimum size of y-axis
) {
  tryCatch(
    {    
        if (dim(df)[1] < 1) {print(plot.new()); return(NULL)}
        require(lattice)
        enl<-eN_list_format(attr(df,"settings"))
      
        y<-ifelse(length(ys)==1,ys,"y")
        df<-reshape(df,direction="long",varying=ys,v.names=y,timevar="set",times=ys)
        if(length(classify)>=2)
        {
          classify<-c(classify[c(1,2)],"set",classify[c(-1,-2)])
        }
        else
        {
          classify<-c(classify,"set")
        }
      
       # if ((length(classify)-1 < factor_x) || factor_x<=0) 
          factor_x<-1
      
        classify <- c(classify[factor_x],classify[-factor_x])
        df=df[df[,which(colnames(df)==y)] <= exclude,]
      
        missn<-""
      
        missb<-rep(F,nrow(df))
        for(j in classify)
        {
          missb<- missb|is.na(df[j])
        }
        if(any(missb)) missn <- paste(sum(missb),"data point(s) excluded due to missing classifier variable")
      
        for(j in c(y))
        {
          missc<-sum(is.na(df[j]))
          if(missc>0) missn<-paste(sep="",missn,";\n",missc," data point(s) excluded due to missing ",j," value") 
        }
        
        means<-  if(length(classify)>0)    aggregate(unlist(df[y]),df[classify],mean,na.rm=T) else data.frame(x=mean(unlist(df[y]),na.rm=T))
      
      #  if(min.y>min(means$x)) min.y=max.y
      #  if(max.y<max(means$x)) max.y=min.y
        if(min.y>=max.y)
        {
          max.y = max(means$x )*1.1-.1*min(means$x)
          min.y = min(means$x )*1.1-.1*max(means$x)    
        }
        yrange<-max.y-min.y
        if (yrange < min.ysep)
        { 
          min.y <- min.y - (min.ysep-yrange)/2
          max.y <- max.y + (min.ysep-yrange)/2
        } 
        
        
        ylimcalced=c(min.y,max.y) 
        if (ylimcalced[1] == ylimcalced[2]) { # plot throws an error
          ylimcalced[1] <- min.y - 0.1*abs(min.y)
          ylimcalced[2] <- min.y + 0.1*abs(min.y)
          }
      
        fmla=if (length(classify)>1) ifelse(
               length(classify)>2,
               paste("x","~as.character(",classify[1],")|",paste(classify[c(-1,-2)],collapse="+")),
               paste("x","~as.character(",classify[1],")|set")
              ) else "x"
      
        print(classify)
        print (fmla)
      
        if(length(classify)>2)
        {
          for(i in 3:length(classify))
          {
            means[,i]<-paste(rep(classify[i],length(unlist(means[classify[i]]))),sep="=",unlist(means[classify[i]]))
          }
        }else
        {
          for(i in length(classify):length(classify))
          {
            means[,i]<-paste(rep(classify[i],length(unlist(means[classify[i]]))),sep="=",unlist(means[classify[i]]))
          }
        }
      
        mysub<-paste(enl,missn,sep="\n")
      
      
        ncolors<-if(length(classify)>0) (length(unique(sort(unlist(means[classify[2]]))))) else 1
        mycolors=c("blue","lightblue","honeydew","lavender","darkgreen","red","purple","khaki")[((1+(0:(ncolors-1))%%8))]
      scarel<-"free"
        if(length(means$set)>1) scarel<-"sliced"
        if(length(classify)>1) { print(barchart(
                       as.formula(fmla),
                       groups=if(length(classify)>2) unlist(means[classify[2]]) else NULL,
                      col=mycolors,
                       sub=mysub,
                       ylim=ylimcalced,
                       ylab=y,
                       xlab=classify[1],
                       data=means,
                       key=if(length(classify)>2) list(text=list(levels(factor(unlist(means[classify[2]])))),
                                rectangles=list(col=mycolors),
                                space="right",
                                title=classify[2]
                                ) else NULL,
                       between=list(x=.5,y=.5),
                       scales=list(
      #                   relation=scarel
                       #  relation=ifelse(length(classify)>2,"sliced","free")
                       )     ,
      horizontal=F
                      )
             ) }else { 
        
        print(barchart(x~rep("Overall",length(ys))|set,ylab=y,col=2,
                      ylim=ylimcalced,
      #                 scales="sliced",
                       data=means,sub=attrib
                         ))
             }
    }, warning = function(w) { print(w); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, error = function(e) { print(e); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, finally = { print ("done");
      
    }
  )       
}
