function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR INDIVIDUAL UNITS
         df=factor(levels=dataframes(eN))[[1]],                  # Settings # data frame to plot
         rampheight=25	                                    # Settings # number of rows on ramping
) {
  require(lattice)
  
  xn<-colnames(df)[2]
  if(grepl("\\./",xn))
  {
    xn<-sub("\\./.*","",xn)
  }
  print(xyplot(
      I(((-1):(dim(df)[1]-2))%%rampheight)~time,df,
      ylab=xn,
      scales=list(y=list(at= c() )),
      panel=function(x,y) {
#        yn=jitter(rep(1,dim(df)[1]),20);
        yn=y
        panel.text(x,yn,apply(as.matrix(df[,-1]),1,function(x) paste(x,collapse=";")));    
        panel.xyplot(x,yn,type="l",col="grey"); 
      }
    )
  )
}
