function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR A SPATIAL LAYER
         df=factor(levels=dataframes(eN))[[1]]                 # Dataframe                      # data frame to plot
) {
  require(lattice)


  cols<-eN_colnamesplit(df)$levels

  nr<-nrow(df)

  df<-df[30*(1:(nr/30)),]

  widget<-  
    function(ex) { 
      ntimes=length(ex); 
      l<-(-10):90/10; 
      temp<-sapply(ex,function(x)
                   {
                     if(length(x)==0) return(rep(0,length(l)));
                     apply(sapply(x,function(y) y[2]*dnorm(l,y[1],.3)),1,sum)
                   }
                  ); 
      data.frame(height=as.vector(temp),
                 location=rep(l,times=ntimes),time=rep(1:ntimes,each=length(l))) 
  }
  
  d<-data.frame(height=NULL,location=NULL,time=NULL,title=NULL)

  for(i in 1:length(cols)) {
    if(sum(unlist(df[,i]))>0){
      d<-rbind(d,
               cbind(
                 widget(df[,i]),
                 data.frame(title=cols[i])
                )
              )
    }
  }

#  print(wireframe(height~location*time|title,d,pretty=T,
#        shade=T,screen=list(x=-70,y=-10,z=-10),aspect=c(1,.5),panel.aspect=.4))

   print(xyplot(height~location|time,groups=title,d,type="b",auto.key=T))
}
