function(                                                      # PLOT ACTIVITY/STATE OVER NODES FOR SPECIFIC TIME 
  df=factor(levels=dataframes(eN))[[1]],                  # Dataframe                      # data frame to plot
  plot.max.vals=factor("TRUE",levels=c("TRUE","FALSE"))[[1]],   # Dataframe   # Plot the maximum value of each node
  time=factor(NULL,levels=df["time"]),               # Dataframe                     # Time slices to plot (ignored if plot.max.vals is TRUE)        
  type=factor("labels",levels=c("bars","positive_bars","points","lines","labels"))[[1]],     # Plot_Type   # Plot bars, bars with positive values, points, lines, or labels
  order=factor("by value",levels=c("by index","by value","random"))[[1]],   # Plot_Type   # Order along x-axis by index, by activity, or randomly
  num_nodes=0,                                        # Plot_Type   # Number of nodes to plot (0=ALL)
         min.y=eN_model_parameter(df,"min_act"),                                              # Cosmetic                # lower limit on y-axis
         max.y=eN_model_parameter(df,"max_act")                                               # Cosmetic                # upper limit on y-axis
) {
  tryCatch(
    {
      
      
      gcolnms<-eN_colnamesplit(df)$levels
      
      colMax <- function(data) sapply(data, max, na.rm = TRUE)  
      if (plot.max.vals=="TRUE") 
      { print(system.time(df <- as.data.frame(t(colMax(df)))))
        time<-1; ncols=1; nrows=1
        #       df<-df[df>=min.y,]
        #       df<-df[df<=max.y,]
        #       print(ncol(df))
        
      } else 
      {
        if (length(time)==0)  
          time = max(df[,colnames(df)=="time"],na.rm=T)
        ncols <- ceiling(sqrt(length(time)))
        nrows <- ceiling(length(time)/ncols)
        df <- df[df$time %in% time,]
      }
      
      print(ncol(df))
      print(max(as.matrix(df[,-1])))
      if(type=="positive_bars") { type="bars"; order="by value"; num_nodes=0; min.y=0.0}
      xlabel="Node Index"
      colbs<-eN_colnamesplit(df)$levelcolb
      if (order=="random") {randvec<-rank(runif(length(gcolnms))); df<-cbind(df["time"],df[,colbs][,randvec]); 
      xlabel="Arbitrary Order"; gcolnms<-gcolnms[randvec] }
      
      ## get y axes
      if (max.y==99) my.max.y={1.05 * max(as.matrix(df[,-1]))} else {my.max.y=max.y}
      if (min.y==99) my.min.y={0.95*min(as.matrix(df[,-1]))} else {my.min.y=min.y}
      
      
      par(mfrow=c(nrows, ncols))
      for (tm in time)
      {    
        if (plot.max.vals=="TRUE") {
          main.label="Maximum value attained" 
          vect = df[,-1]
        } else 
        {
          main.label=paste("Time =", tm) 
          t.row = which(df$time==tm)[1]
          vect = df[t.row,-1]
        }
        colnms=gcolnms
        print(system.time(if (order=="by value") { colnms=colnms[order(vect,decreasing=T)]; 
        vect=vect[order(vect,decreasing=T)]; xlabel="Rank" }))
        
        vect<-as.vector(as.matrix(vect))
        vidx <- which(vect>my.min.y & vect<my.max.y)
        colnms=colnms[vidx]
        vect<-vect[vidx]
        if (num_nodes>0) {vect=vect[1:num_nodes]; colnms<-colnms[1:num_nodes]}
        
        print("line75")
        print(system.time(if (length(vect)==0) { vect=NA; main.label <- "Missing Data (no values in selected range?)"}))
        
        ptype<-"n"
        if(type=="points") ptype<-"p"
        if(type=="lines") ptype<-"l"
        if(type=="bars") 
        {
          plt <- barplot (t(matrix(vect)),
                          xlab=xlabel,
                          ylab="Node Activity",
                          main=main.label,
                          ylim=c(my.min.y,my.max.y),
                          col="lightgreen"
          )
          # {plt<-text(0.7,0.5*(my.max.y+my.max.y),"Missing Data (no positive values?)",cex=2)} else
          if (length(vect)>0) plt <- text(x=plt, vect, label=colnms, pos = 3, xpd = NA)
        } else {
          
          plt <-   plot(1:length(vect),vect,
                        xlab=xlabel,
                        ylab="Node Activity",
                        main=main.label,
                        ylim=c(my.min.y,my.max.y),
                        pch=16,
                        type=ptype)
          
          
          # {plt<-text(diff(par(plt)[1:2])/2,0.5*(my.max.y+my.max.y),"Missing Data (no values in selected range?)",cex=2)} else
          if ((length(vect)>0) && (type=="labels")) plt <- text(1:length(vect),vect,labels=colnms)
          plt <- grid()
        }
        
        print (plt)
      }
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
      
    }
  )
  
}  
