function(                                                      # PLOT OPEN BIGRAM MATCH FOR SPECIFIC TEMPLATE 
  template=factor(NULL,levels=eN_colnamesplit(word.list)$levels),   # Match                # String to match bigram activity with (enclose in "")    
  df=factor(levels=dataframes(eN))[[1]],                            # Dataframe            # data frame to plot
  plot.max.vals=factor("TRUE",levels=c("TRUE","FALSE"))[[1]],       # Dataframe            # Plot the maximum value of each node
  time=factor(NULL,levels=df["time"]),                              # Dataframe            # Time slices to plot (ignored if plot.max.vals is TRUE)        
         min.y=eN_model_parameter(df,"min_act"),                    # Cosmetic             # lower limit on y-axis
         max.y=eN_model_parameter(df,"max_act")                     # Cosmetic             # upper limit on y-axis
) {
  tryCatch(
    {
            stimulus<-attributes(eN["(bigrams default_observer)"])$settings$stimulus
            if (is.null(stimulus)) stimulus<-paste0(attributes(eN["(bigrams default_observer)"])$settings$prime,"-",
                                                    attributes(eN["(bigrams default_observer)"])$settings$target)
            
            if (is.null(stimulus)) stimulus=""
            
            require(grid)
            # determine OBs in template
            if(is.null(template)) template=stimulus
            if(grepl("-",template)) template<-strsplit(template,"-")[[1]][2]
            bg<-NULL; bglist<-NULL
            if (nchar(template) > 1)
            {
              for (i in 1:(nchar(template)-1))
              {
                txt<-substr(template,i,nchar(template))
                n<-nchar(txt)
                mstr<-paste0("^",paste0(rep("(.)",n),collapse=""))
                rstr<-paste0(sub("(.)(.)", "\\\\\\1\\\\\\2", paste0(1,2:(min(4,n))), perl=TRUE),collapse="")
                bg<-c(bg,sub(mstr,rstr,txt,perl=T))
              }
              
              sst <- strsplit(paste0(bg,collapse=""), "")[[1]]
              bglist <- paste0(sst[c(TRUE, FALSE)], sst[c(FALSE, TRUE)])
            }
            print(bglist)
            
            gcolnms<-eN_colnamesplit(df)$levels
          #  print(gcolnms)
            
            colMax <- function(data) sapply(data, max, na.rm = TRUE)  
            if (plot.max.vals=="TRUE") 
            { print(system.time(df <- as.data.frame(t(colMax(df)))))
              time<-1; ncols=1; nrows=1
              #       df<-df[df>=min.y,]
              #       df<-df[df<=max.y,]
              #       print(ncol(df))
              
            } else 
            {
              if (length(time)==0)  
                time = max(df[,colnames(df)=="time"],na.rm=T)
              ncols <- ceiling(sqrt(length(time)))
              nrows <- ceiling(length(time)/ncols)
              df <- df[df$time %in% time,]
            }
            
            xlabel="Bigram"
            colbs<-eN_colnamesplit(df)$levelcolb
          
            ## get y axes
            if (max.y==99) my.max.y={1.05 * max(as.matrix(df[,-1]))} else {my.max.y=max.y}
            if (min.y==99) my.min.y={0.95*min(as.matrix(df[,-1]))} else {my.min.y=min.y}
            print("line 51")
            
            
            par(mfrow=c(nrows, ncols))
            for (tm in time)
            {    
              if (plot.max.vals=="TRUE") {
                main.label="Maximum value attained" 
                vect = df[,-1]
              } else 
              {
                main.label=paste("Time =", tm) 
                t.row = which(df$time==tm)[1]
                vect = df[t.row,-1]
              }
              # main.label=paste0("Open bigram match: Stimulus: ",stimulus,"   Template: \"",template,"\"") 
              colnms=gcolnms
          
              vect<-as.vector(as.matrix(vect))
              vidx <- which(vect>my.min.y & vect<my.max.y)
              colnms=colnms[vidx]
              vect<-vect[vidx]
          
              # create two vectors -- one containing those nodes that were expected
              # and one containing those that weren't but were active
              
              exp.idx<-as.vector(na.omit(unique(match(bglist,colnms))))
              print(exp.idx)
              vect1<-vect[exp.idx]; colnms1<-colnms[exp.idx]; cols1<-rep("green3",length(vect1))
              num.match<-sum(vect1>0);num.exp<-length(vect1)
              match<-sum(vect1>0)/length(vect1)
              act.match<-sum(vect1) # /length(vect1)
              cols1[which(vect1==0)]<-"green3"
          
              vect2<-NULL; colnms2<-NULL; cols2<-NULL
              active<-which(vect>0 & !(colnms %in% colnms1))
              vect2<-vect[active];colnms2<-colnms[active];cols2<-rep("red",length(vect2))
              count.mismatch<-sum(vect2>0)
              act.mismatch<-sum(vect2)    
              vect<-c(vect1,vect2); colnms<-c(colnms1,colnms2); cols<-c(cols1,cols2)
              
              if (length(vect)==0) { vect=NA; main.label <- "Missing Data (no values in selected range?)"}
              
                plt <-   plot(1:length(vect),vect,
                              xaxt="n",
                              xlab="", #xlabel,
                              ylab="Node Activity",
                              main="", #main.label,
                              xlim=c(0,(length(vect)+1)),
                              ylim=c(my.min.y,my.max.y),
                              pch=16,
                              type="n")
                
                
                fs<-min(3,2*13/length(cols))
                if ((length(vect)>0)) plt <- text(1:length(vect),vect,labels=colnms,col=cols,font=2,cex=fs)
                grid.text(paste("Count-Match =",num.match,"/",num.exp,"=",sprintf("%.2f",match)),
                          unit(.25, 'npc'), unit(0.09, 'npc'), gp=gpar(col="green3",cex=1.5,font=2))
                grid.text(paste("Act-Match =",sprintf("%.2f",act.match)),
                          unit(.25, 'npc'), unit(0.05, 'npc'), gp=gpar(col="green3",cex=1.5,font=2))
                
                grid.text(paste("Count-Mismatch =",sprintf("%1d",count.mismatch)),
                          unit(.8, 'npc'), unit(0.09, 'npc'), gp=gpar(col="red",cex=1.5,font=2))
                grid.text(paste("Act-Mismatch =",sprintf("%.2f",act.mismatch)),
                          unit(.8, 'npc'), unit(0.05, 'npc'), gp=gpar(col="red",cex=1.5,font=2))
                
                grid.text("Open bigram match",
                          unit(.5, 'npc'), unit(0.98, 'npc'), gp=gpar(col="black",cex=1.5,font=2))
                grid.text(paste0("Template: \"",template,"\"     Stimulus: \"",stimulus,"\""), 
                          unit(.5, 'npc'), unit(0.93, 'npc'), gp=gpar(col="black",cex=1.5,font=2))
                plt <- grid()
          
              print (plt)
            }
    }, warning = function(w) { print(w); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, error = function(e) { print(e); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
    
    }, finally = { print ("done"); # plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")
      
    }
  )            
}  
