function(                                                      # PLOT ACTIVITY/STATE OVER TIME FOR INDIVIDUAL UNITS
         df=factor(levels=dataframes(eN))[[1]],                  # Settings # data frame to plot
         rampheight=20	                                    # Settings # number of rows on ramping
) {
  require(lattice)
  
  xn<-colnames(df)[2]
  if(grepl("\\./",xn))
  {
    xn<-sub("\\./.*","",xn)
  }
  loly<-((-1):(dim(df)[1]-2))%%rampheight
  loly<-loly+.5*floor((1:length(loly))/rampheight)%%2
loly<- -loly
  horiz<- -round(runif(1),2)
  print(xyplot(
      loly~time,df,
      ylab=xn,
      scales=list(y=list(at= c() )),
      panel=function(x,y) {
        mdf<-df[,-1]
        randx=round(runif(ncol(mdf))+1:ncol(mdf),2)+horiz
        spec<-paste(sep="","(",randx,"):[",1:ncol(mdf)+horiz,",",1:ncol(mdf)+1+horiz,"]")
        spec[1]<-sub("\\[","\\[B",spec[1])
        spec[length(spec)]<-sub("\\]","\\]",spec[length(spec)])
        mdf<-mapply(paste,mdf,spec,sep="")
        tx=apply(mdf,1,function(x) paste(x,collapse=";"));
        tx<-gsub("__[^;]*(;|$)","",tx)
        tx<-gsub("];$","E];",tx)
        tx<-gsub("_#[^;]*;","",tx)
        tx<-gsub("(.)#([^:]*):[^;]*","\\1\\2",tx)
        tx<-gsub("(.)\\1\\([^\\)]*\\):","\\1",tx)
    #    tx<-gsub(";","",tx)

        yn=y
        panel.xyplot(x,yn,type="l",col="grey"); 
        panel.text(x,yn,tx);    
      }
    )
  )
}
