function(                                                           # PLOT HISTOGRAM
  df=factor(levels=dataframes(eN))[[1]],                            # Settings             # Dataframe with DV(s) and IV(s)
  dv=factor(NULL,levels=colnames(df))[[1]],                              # Settings   # name of column(s) in dataframe to be plotted
  exclude=1000,                                                     # Settings   # exclude trials with values on DV greater than this value
  omit_missing_data=factor("TRUE",levels=c("TRUE","FALSE"))[[1]]    # Settings            # should missing data be skipped in calculation?
) {
  tryCatch(
    {  
      # watch out for parameter names 
      names(df)<-gsub("::","_",names(df))
      dv<-gsub("::","_",dv)
      
        attrib<-eN_list_format(attr(df,"settings"))
      
      df<-reshape(df,direction="long",varying=dv,v.names="y",timevar="set",times=dv)
      y<-"y"
      
    
      df=df[df[,which(colnames(df)==y)] <= exclude,]
      if (! is.numeric(df$y)) {print("got here"); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="",main = "Data must be numeric"));} else
      print(hist(df$y,main=paste("Histogram of",dv),xlab=dv))
    

    }, warning = function(w) { print(w); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
      
    }, error = function(e) { print(e); plt <- plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab=""); return
      
    }, finally = { print ("done");
    
  }
)  
}

  

 