function(                                                  # A BOX PLOT OF MEANS BY CATEGORIES
  df=factor(levels=dataframes(eN))[[1]],           # Dataframe                     # Dataframe with DV(s) and IV(s)
  ys=factor(NULL,levels=colnames(df)),                   # Dependent Variables            # name of column(s) in dataframe to be averaged
  exclude=1000,                                     # Dependent Variables          # exclude trials with values on DV greater than this value
  classify=factor(NULL,levels=colnames(df)),        # Independent Variables         # IV(s) from df (if any)
  factor_x=1,                                        # Independent Variables         # IV no. to plot on x-axis
  min.y=.0/.0,                                              # Cosmetic # lower limit on y-axis
  max.y=.0/.0,                                               # Cosmetic # upper limit on y-axis
  min.ysep=.0/.0,                                            # Cosmetic # minimum size of y-axis
  x.axis.label="",                                          # Cosmetic    # label for x-axis
  y.axis.label=""                                           # Cosmetic    # label for y-axis
) {
  tryCatch(
    {
      
      if (dim(df)[1] < 1) {return(NULL)}
      require(lattice)
      
      attrib<-eN_list_format(attr(df,"settings"))
      
      df<-reshape(df,direction="long",varying=ys,v.names="y",timevar="set",times=ys)
      y<-"y"
    
      if ((length(classify)-1 < factor_x) || factor_x<=0) 
        factor_x<-1
      
      classify <- c(classify[factor_x],classify[-factor_x])
      df=df[df[,which(colnames(df)==y)] <= exclude,]
      missn<-""
    
      missb<-rep(F,nrow(df))
      for(j in classify)
      {
        missb<- missb|is.na(df[j])
      }
      if(any(missb)) missn <- paste(sum(missb),"data point(s) excluded due to missing classifier variable")
    
      for(j in c(y))
      {
        missc<-sum(is.na(df[j]))
        if(missc>0) missn<-paste(sep="",missn,";\n",missc," data point(s) excluded due to missing ",j," value") 
      }
    
      ymax = max(df$y )
      ymin = min(df$y )
      yrange=ymax-ymin
      if (yrange < 30) yrange = 30
      .eN.float.YMAX = 0.3 * yrange + ymax
      .eN.float.YMIN = ymin - 0.2 * yrange
      
      fmla=paste("y","~",paste(classify,collapse="+"))
      mysub<-paste(attrib,missn,sep="\n")
      
      print(classify)
      print (fmla)
      print (head(df))
    #  df$N = as.factor(df$N)
    #   ncolors<-if(length(classify)>0) (length(unique(sort(unlist(means[classify[min(length(classify),factor_x)]]))))) else 1
    #   mycolors=c("blue","lightblue","honeydew","lavender","darkgreen","red","purple","khaki")[((1+(0:(ncolors-1))%%8))]
      print(  boxplot(as.formula(fmla), 
                       data=df,
                     sub=mysub,
                       ylab=y.axis.label, cex.lab=1.5, cex.axis=1.25,
                       xlab=x.axis.label 
                      )
            )
    }, warning = function(w) { print("warning"); print(w); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, error = function(e) { print("error"); print(e); print(plot(0,0,"n",xaxt="n",yaxt="n",xlab="",ylab="")); return
      
    }, finally = { print("done"); 
      
    }
  )
  
  
}

  

 