function(                                       # COMPUTE RESTING ACTIVITY BASED ON WORD FREQUENCY
         df=factor(levels=dataframes(eN))[[1]], # Dataframe                      # data frame containing word frequency info
         freq=factor(NULL,levels=colnames(df))[[1]],  # Dataframe                      # columns containing word frequency info
         model=factor(NULL,levels=c("ia","ia88"))[[1]] # Dataframe                      # model class (ia includes original ia, bia, rpm-ia, oob-ia; ia88 gives resting activities as in PDP book)
) {
  tryCatch(
    {  
      if(is.null(freq)) return(df);
      
      if (model=="ia88") { ## this is the (undocumented) version used to produce 
        ## the original resting activities included with the source code of the PDP book.
        df<-df[df[,freq]>0,]
        df$logf<-log(log(df[,freq]+1))
        df$Rest=NA
        M<-max(df$logf[-which(df$logf==max(df$logf))])
        m<-min(df$logf)
        df$Rest=(.9262-.0179)*(df$logf-M)/(M-m) - .0179
        df$Rest[which(df$logf==max(df$logf))]=0
        
      } else { ## this is the version described on p 216 of the PDP book
      
        # exclude any words with non-positive freq
        df<-df[df[,freq]>0,]
        df$logf<-log(df[,freq])
        df$Rest=NA
        M<-max(df$logf[-which(df$logf==max(df$logf))])
        m<-min(df$logf)
        df$Rest=.91*(df$logf-M)/(M-m) - .01
        df$Rest[which(df$logf==max(df$logf))]=0
      }
      
      df
    }, warning = function(w) { print(w); #return(data.frame(warning=as.character(w$message)))
      
    }, error = function(e) { print(e); err<-data.frame(error=as.character(e$message));err$error=as.character(err$error); return(err)
    
    }, finally = { 
      
    }
  )  
  
}
